package service;


public class SimpleTransitionImpl extends SimpleTransition {
	State from, to;
	/**
	 * Creates a new simple action
	 * @param name the name that identifies the action.
	 * @param from the source state of the composed action
	 * @param to the target state of the composed action
	 */	

	public SimpleTransitionImpl(String name, State from, State to){
		super(name, from, to);
		this.from = from;
		this.to = to;
	}

	/**
	 * This method returns the hashCode of the action
	 * @return The result contains the hashCode of the action
	 */
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((from == null) ? 0 : from.hashCode());
		result = prime * result + ((to == null) ? 0 : to.hashCode());
		result = prime * result
				+ ((getName() == null) ? 0 : getName().hashCode());
		return result;
	}

	/**
	 * This method compares a simple action with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a SimpeAction and the name,the target state and the source state of the two SimpleAction are equals.
	 */

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		SimpleTransitionImpl other = (SimpleTransitionImpl) obj;
		if (from == null) {
			if (other.from != null)
				return false;
		} else if (!from.equals(other.from))
			return false;
		if (to == null) {
			if (other.to != null)
				return false;
		} else if (!to.equals(other.to))
			return false;
		if (!other.getName().equals(getName()))
			return false;
		return true;
	}

	/** This method returns the source state of the action
	 * @return the source state of the action
	 */
	public State getStateFrom() {
		return this.from;
	}
	/** This method returns the target state of the action
	 * @return the target state of the action
	 */
	public State getStateTo() {
		return this.to;
	}

}
